-- T-SQL Window Function Deep Dive
-- POC Index
--(check indexes before beginning)
USE AdventureWorks2014;
GO
SET STATISTICS IO ON;
GO
SET NOCOUNT ON;
GO


--Ranking
SELECT CustomerID, SalesOrderID, OrderDate, TotalDue, 
	ROW_NUMBER() 
	OVER(PARTITION BY CustomerID ORDER BY SalesOrderID) AS RowNum
FROM Sales.SalesOrderHeader;

--Windows Aggregate function
SELECT CustomerID, SalesOrderID, OrderDate, TotalDue,
	SUM(TotalDue) OVER(PARTITION BY CustomerID) AS CustTotal
FROM Sales.SalesOrderHeader;

--Running total
SELECT CustomerID, SalesOrderID, OrderDate, TotalDue,
	SUM(TotalDue) 
	OVER(PARTITION BY CustomerID ORDER BY SalesOrderID) AS RunningTotal
FROM Sales.SalesOrderHeader;

--Analytic function - Frame not supported
SELECT CustomerID, SalesOrderID, OrderDate, TotalDue,
	LAG(SalesOrderID) 
	OVER(PARTITION BY CustomerID ORDER BY SalesOrderID) AS PrevOrder
FROM Sales.SalesOrderHeader;

--Analytic function -- Frame supported
SELECT CustomerID, SalesOrderID, OrderDate, TotalDue,
	FIRST_VALUE(SalesOrderID) 
	OVER(PARTITION BY CustomerID ORDER BY SalesOrderID) AS PrevOrder
FROM Sales.SalesOrderHeader;

--POC index: partition, order by, covering
CREATE NONCLUSTERED INDEX Perf1 ON Sales.SalesOrderHeader
	(CustomerID, SalesOrderID) INCLUDE(OrderDate,TotalDue);


--Now check again
--Ranking
SELECT CustomerID, SalesOrderID, OrderDate, TotalDue, 
	ROW_NUMBER() 
	OVER(PARTITION BY CustomerID ORDER BY SalesOrderID) AS RowNum
FROM Sales.SalesOrderHeader;

--Windows Aggregate function
SELECT CustomerID, SalesOrderID, OrderDate, TotalDue,
	SUM(TotalDue) OVER(PARTITION BY CustomerID) AS CustTotal
FROM Sales.SalesOrderHeader;

--Running total
SELECT CustomerID, SalesOrderID, OrderDate, TotalDue,
	SUM(TotalDue) 
	OVER(PARTITION BY CustomerID ORDER BY SalesOrderID) AS RunningTotal
FROM Sales.SalesOrderHeader;

--Analytic function - Frame not supported
SELECT CustomerID, SalesOrderID, OrderDate, TotalDue,
	LAG(SalesOrderID) 
	OVER(PARTITION BY CustomerID ORDER BY SalesOrderID) AS PrevOrder
FROM Sales.SalesOrderHeader;

--Analytic function -- Frame supported
SELECT CustomerID, SalesOrderID, OrderDate, TotalDue,
	FIRST_VALUE(SalesOrderID) 
	OVER(PARTITION BY CustomerID ORDER BY SalesOrderID) AS PrevOrder
FROM Sales.SalesOrderHeader;

--Descending order
SELECT CustomerID, SalesOrderID, OrderDate, TotalDue, 
	ROW_NUMBER() 
	OVER(PARTITION BY CustomerID ORDER BY SalesOrderID DESC) AS RowNum
FROM Sales.SalesOrderHeader;


CREATE INDEX Perf2 ON Sales.SalesOrderHeader
	(CustomerID, SalesOrderID DESC) INCLUDE(OrderDate, TotalDue);

SELECT CustomerID, SalesOrderID, OrderDate, TotalDue, 
	ROW_NUMBER() OVER(PARTITION BY CustomerID 
	ORDER BY SalesOrderID DESC) AS RowNum
FROM Sales.SalesOrderHeader
ORDER BY CustomerID, SalesOrderID DESC;


--Existing indexes: 
--Clustered on TransactionID, Nonclustered on ProductID + 
--TransactionDate Includes Quantity & ActualCost 
--Just run estimated execution plan!
--TransactionID in the cluster key so it is included in the NC index
SELECT ProductID, TransactionID, 
	ROW_NUMBER() OVER(PARTITION BY ProductID ORDER BY TransactionID)
FROM bigTransactionHistory;

--In this case, the ORDER BY column needs to be in the NC index
SELECT ProductID, TransactionID, 
	ROW_NUMBER() OVER(PARTITION BY ProductID ORDER BY TransactionDate)
FROM bigTransactionHistory;


--How does a Column Store Index affect performance?
SELECT Row_number() OVER(PARTITION BY productid ORDER BY salesorderid)
FROM dbo.SalesOrderDetail WITH (INDEX([CSX_SalesDetails_AllColumns]));

SELECT Row_number() OVER(PARTITION BY productid ORDER BY salesorderid)
FROM dbo.SalesOrderDetail WITH (INDEX([IX_SalesOrderDetail_ProductIDSalesOrderID]));	


--Multiple tables?
--Sort 
--If run with now results 0 seconds
SELECT CustomerID, ProductID, SOH.OrderDate,SOH.SalesOrderID,
	ROW_NUMBER() OVER(PARTITION BY SOH.CustomerID 
		ORDER BY SOH.SalesOrderID) AS RowNum
FROM Sales.SalesOrderHeader AS SOH
JOIN Sales.SalesOrderDetail AS SOD ON SOH.SalesOrderID = SOD.SalesOrderID;

--if run with no results 1 second
SELECT C.CustomerID, ProductID, S.OrderDate, S.SalesOrderID,RowNum
FROM Sales.Customer AS C 
CROSS APPLY(
	SELECT ProductID, SOH.OrderDate,SOH.SalesOrderID,
		ROW_NUMBER() OVER(ORDER BY SOH.SalesOrderID) AS RowNum
	FROM Sales.SalesOrderHeader AS SOH
	JOIN Sales.SalesOrderDetail AS SOD ON SOH.SalesOrderID = SOD.SalesOrderID
	WHERE SOH.CustomerID = C.CustomerID) AS S;

--Parallellism
--Run with no results, 2 sec
SELECT ProductID, TransactionID, 
	ROW_NUMBER() OVER(PARTITION BY 
		ProductID ORDER BY TransactionDate) AS RowNum
FROM tinyTransactionHistory H;

--run with no results, 1 sec
SELECT ProductID, TH.TransactionID, TH.RowNum
FROM tinyProduct AS P
CROSS APPLY(
	SELECT TransactionID, 
		ROW_NUMBER() OVER(ORDER BY TransactionDate) AS RowNum
	FROM tinyTransactionHistory H 
	WHERE H.ProductID = P.ProductID) AS TH;

